/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericRecipe
implements IGenericRecipe {
    private final ItemStack output;
    private final List<ItemStack> allMultiOutputs;
    private final List<ItemStack> additionalOutputs;
    private final List<List<ItemStack>> inputs;
    private final int gridSize;
    private final Block intermediate;
    private final ResourceLocation lootTable;
    private final List<ITextComponent> restrictions;
    private final int levelSort;

    @Nullable
    public static IGenericRecipe of(@Nullable IRecipe<?> recipe) {
        Block intermediate;
        int size;
        if (recipe == null) {
            return null;
        }
        List<List<ItemStack>> inputs = recipe.func_192400_c().stream().map(ingredient -> Arrays.asList(ingredient.func_193365_a())).collect(Collectors.toList());
        if (recipe instanceof FurnaceRecipe) {
            size = 1;
            intermediate = Blocks.field_150460_al;
        } else {
            size = recipe.func_194133_a(2, 2) ? 2 : 3;
            intermediate = Blocks.field_150350_a;
        }
        return new GenericRecipe(recipe.func_77571_b(), GenericRecipe.calculateSecondaryOutputs(recipe), inputs, size, intermediate, null, new ArrayList<ITextComponent>(), -1);
    }

    @Nullable
    public static IGenericRecipe of(@Nullable IRecipeStorage storage, @NotNull List<ITextComponent> restrictions, int levelSort) {
        if (storage == null) {
            return null;
        }
        List<List<ItemStack>> inputs = storage.getCleanedInput().stream().map(input -> Collections.singletonList(GenericRecipe.toItemStack(input))).collect(Collectors.toList());
        return new GenericRecipe(storage.getPrimaryOutput(), storage.getAlternateOutputs(), storage.getSecondaryOutputs(), inputs, storage.getGridSize(), storage.getIntermediate(), storage.getLootTable(), restrictions, levelSort);
    }

    @Nullable
    public static IGenericRecipe of(@Nullable IRecipeStorage storage) {
        return GenericRecipe.of(storage, new ArrayList<ITextComponent>(), -1);
    }

    @Nullable
    public static IGenericRecipe of(@Nullable IToken<?> recipeToken) {
        if (recipeToken == null) {
            return null;
        }
        return GenericRecipe.of((IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(recipeToken));
    }

    public GenericRecipe(@NotNull ItemStack output, @NotNull List<ItemStack> additionalOutputs, @NotNull List<List<ItemStack>> inputs, int gridSize, @NotNull Block intermediate, @Nullable ResourceLocation lootTable, @NotNull List<ITextComponent> restrictions, int levelSort) {
        this.output = output;
        this.allMultiOutputs = Collections.singletonList(output);
        this.additionalOutputs = Collections.unmodifiableList(additionalOutputs);
        this.inputs = Collections.unmodifiableList(inputs);
        this.gridSize = gridSize;
        this.intermediate = intermediate;
        this.lootTable = lootTable;
        this.restrictions = Collections.unmodifiableList(restrictions);
        this.levelSort = levelSort;
    }

    public GenericRecipe(@NotNull ItemStack output, @NotNull List<ItemStack> altOutputs, @NotNull List<ItemStack> additionalOutputs, @NotNull List<List<ItemStack>> inputs, int gridSize, @NotNull Block intermediate, @Nullable ResourceLocation lootTable, @NotNull List<ITextComponent> restrictions, int levelSort) {
        this.output = output;
        this.allMultiOutputs = Collections.unmodifiableList(Stream.concat(Stream.of(output), altOutputs.stream()).collect(Collectors.toList()));
        this.additionalOutputs = Collections.unmodifiableList(additionalOutputs);
        this.inputs = Collections.unmodifiableList(inputs);
        this.gridSize = gridSize;
        this.intermediate = intermediate;
        this.lootTable = lootTable;
        this.restrictions = Collections.unmodifiableList(restrictions);
        this.levelSort = levelSort;
    }

    @Override
    public int getGridSize() {
        return this.gridSize;
    }

    @Override
    @NotNull
    public ItemStack getPrimaryOutput() {
        return this.output;
    }

    @Override
    @NotNull
    public List<ItemStack> getAllMultiOutputs() {
        return this.allMultiOutputs;
    }

    @Override
    @NotNull
    public List<ItemStack> getAdditionalOutputs() {
        return this.additionalOutputs;
    }

    @Override
    @NotNull
    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    @Override
    @NotNull
    public List<ITextComponent> getRestrictions() {
        return this.restrictions;
    }

    @Override
    public int getLevelSort() {
        return this.levelSort;
    }

    @Override
    public boolean matchesOutput(@NotNull Predicate<ItemStack> predicate) {
        return predicate.test(this.output);
    }

    @Override
    public boolean matchesInput(@NotNull Predicate<ItemStack> predicate) {
        for (List<ItemStack> slot : this.inputs) {
            for (ItemStack stack : slot) {
                if (!predicate.test(stack)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Block getIntermediate() {
        return this.intermediate;
    }

    @Override
    @Nullable
    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public String toString() {
        return "GenericRecipe{output=" + this.output + '}';
    }

    @NotNull
    private static ItemStack toItemStack(@NotNull ItemStorage input) {
        ItemStack result = input.getItemStack().func_77946_l();
        result.func_190920_e(input.getAmount());
        return result;
    }

    @NotNull
    private static List<ItemStack> calculateSecondaryOutputs(@NotNull IRecipe<?> recipe) {
        if (recipe instanceof ICraftingRecipe) {
            NonNullList inputs = recipe.func_192400_c();
            CraftingInventory inv = new CraftingInventory(new Container(ContainerType.field_221518_l, 0){

                public boolean func_75145_c(@NotNull PlayerEntity playerIn) {
                    return false;
                }
            }, 3, 3);
            for (int slot = 0; slot < inputs.size(); ++slot) {
                ItemStack[] stacks = ((Ingredient)inputs.get(slot)).func_193365_a();
                if (stacks.length <= 0) continue;
                inv.func_70299_a(slot, stacks[0]);
            }
            if (((ICraftingRecipe)recipe).func_77569_a((IInventory)inv, null)) {
                return ((ICraftingRecipe)recipe).func_179532_b((IInventory)inv).stream().filter(ItemStackUtils::isNotEmpty).filter(stack -> stack.func_77973_b() != ModItems.buildTool.get()).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }
}

